# LinkDir (Hardened) — Quick Install

This package includes security hardening patches:
- Fixed admin middleware access control
- Removed default seeded admin credentials from migrations
- Added optional initial admin seeding via env vars
- Tightened URL and file upload validation
- Safer default `.env` (production + debug disabled)

## Requirements
- PHP 7.4+ recommended (script was originally built for PHP 7.x/Laravel 7)
- MySQL/MariaDB
- Composer

## Install steps

1) **Upload** the app to your web root (or a subfolder) and point your vhost/document root to the `public/` directory.

2) **Create your env file**

Copy `.env.example` to `.env` (or edit the included `.env`) and set:
- `APP_URL`
- DB settings (`DB_HOST`, `DB_DATABASE`, `DB_USERNAME`, `DB_PASSWORD`)

3) **Generate the app key**

```bash
php artisan key:generate
```

4) **Install dependencies**

```bash
composer install --no-dev --optimize-autoloader
```

5) **Run migrations**

```bash
php artisan migrate
```

6) **Create the initial admin (recommended)**

Set these in `.env`:

```
ADMIN_NAME=YourName
ADMIN_EMAIL=you@example.com
ADMIN_PASSWORD=UseA_StrongPasswordHere
ADMIN_TYPE=Owner
```

Then run:

```bash
php artisan db:seed
```

7) **Production optimizations**

```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## Notes
- Keep `APP_DEBUG=false` on production.
- Make sure the `storage/` and `bootstrap/cache/` directories are writable by the web server.
