# Security Notes

## What was fixed in this hardened build

1) **Admin access control**
   - The original `CheckAdmin` middleware compared a `User` object to a string, so admin routes were effectively not protected.
   - Fixed to require authentication and allow only `users.type` in `{owner, admin}`.

2) **Default admin credentials removed**
   - The original migration inserted a known `admin@site.com` / `12345678` account.
   - Removed. Initial admin can now be created via `php artisan db:seed` using env vars.

3) **Safer env defaults**
   - `.env` now defaults to `APP_ENV=production`, `APP_DEBUG=false`, and `APP_KEY` blank until generated.

4) **Input & upload validation tightened**
   - Link URL is now validated as a real URL and allows up to 255 chars.
   - Icon upload now validates image type + size.

## Remaining risk: End-of-life framework

This script targets **Laravel 7** and originally targeted **PHP 7.2**.

Those versions are end-of-life and no longer receive security patches.
For long-term safety, plan to upgrade the application to a supported Laravel/PHP stack.
