<?php

namespace App\Http\Controllers;

use App\Comment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CommentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $stars = request('stars');

        $comment = new Comment();
        $comment->user_id = Auth::id();
        $comment->stars = request('stars');
        $comment->score = $stars / 5;
        $comment->link_id = request('link_id');
        $comment->body = request('body');
        $comment->save();

        // Calculate the stars and scores
        $sumscore = Comment::where('link_id', $comment->link->id)->sum('score');
        $ratecount = Comment::where('link_id', $comment->link->id)->count();
        $displaystars = ($sumscore / $ratecount) * 5;
        $comment->link->star = $displaystars;
        
        $comment->link->save();

        return redirect()->back()->withMessage('Comment posted');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Comment  $comment
     * @return \Illuminate\Http\Response
     */
    public function show(Comment $comment)
    {
        return view('links.stars', compact('comment')); // Not in use
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Comment  $comment
     * @return \Illuminate\Http\Response
     */
    public function edit(Comment $comment)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Comment  $comment
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Comment $comment)
    {
        $stars = request('stars');

        $comment->user_id = Auth::id();
        $comment->stars = request('stars');
        $comment->link_id = request('link_id');
        $comment->score = $stars / 5;
        $comment->body = request('body');

        $comment->update();

        // Calculate the stars and scores
        $sumscore = Comment::where('link_id', $comment->link->id)->sum('score');
        $ratecount = Comment::where('link_id', $comment->link->id)->count();

        // if ($ratecount == 0) {
        //     //
        // } else {
            $displaystars = ($sumscore / $ratecount) * 5;

            $comment->link->star = $displaystars;
        // }
        
        $comment->link->save();
        return redirect()->back()->withMessage('Your comment updated successfully !');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Comment  $comment
     * @return \Illuminate\Http\Response
     */
    public function destroy(Comment $comment)
    {
        $comment->delete();

        // Calculate the stars and scores
        $sumscore = Comment::where('link_id', $comment->link->id)->sum('score');
        $ratecount = Comment::where('link_id', $comment->link->id)->count();

            $displaystars = ($sumscore / $ratecount) * 5;

            $comment->link->star = $displaystars;
        
        $comment->link->save();
        return redirect()->back()->withMessage('Your comment is deleted.');
    }
}
