<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Link;

class SearchController extends Controller
{

    public function search(Request $request)
    {
        $this->validate($request, [
            'q' => 'required',
        ]);
        $links = Link::where('title', 'like', '%' . $request->q . '%')->orWhere('description', 'like', '%' . $request->q . '%')->paginate('10');
    
        return view('links.search', compact('links'));
    }
}