<nav class="navbar navbar-expand-md navbar-dark bg-primary mb-0">
    <div class="container">
        <a class="navbar-brand" href="{{ url('/') }}">
            {{ config('app.name', 'LinkDir') }}
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <!-- Left Side Of Navbar -->
            <ul class="navbar-nav mr-auto">
                @auth
                <li class="nav-item">
                    <a class="nav-link {{Request::is('home') ? 'active' : ''}}" href="{{ route('home') }}">{{ __('Dashboard') }}</a>
                </li>
                @endauth
                <li class="nav-item">
                    <a class="nav-link {{Request::is('link') ? 'active' : ''}}" href="{{ route('link.index') }}">List</a>
                </li>
            </ul>

            <!-- Right Side Of Navbar -->
            <ul class="navbar-nav ml-auto">
                <!-- Authentication Links -->
                @guest
                    <li class="nav-item">
                        <a class="nav-link {{Request::is('login') ? 'active' : ''}}" href="{{ route('login') }}">{{ __('Login') }}</a>
                    </li>
                    @if (Route::has('register'))
                        <li class="nav-item">
                            <a class="nav-link {{Request::is('register') ? 'active' : ''}}" href="{{ route('register') }}">{{ __('Register') }}</a>
                        </li>
                    @endif
                @else

                        @if ( Auth::user()->links()->count() < $admin->limitpost )
                            <li class="nav-item">
                                <a href="{{ route('link.create') }}" class="btn btn-primary {{Request::is('link/create') ? 'active' : ''}}">Add new</a>                                
                            </li>
                        @else
                            <li class="nav-item">
                                <button type="button" class="btn btn-secondary" disabled>Add new</button>
                            </li>
                        @endif

                    <li class="nav-item dropdown">
                        <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                            {{ Auth::user()->name }}
                        </a>
                        
                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                            <!-- Check for admin start -->
                            @if (Auth::user()->type == 'Admin' || Auth::user()->type == 'Owner')
                                <div class="visible">
                                    <a class="dropdown-item" href="{{ route('adminpanel') }}">Admin panel</a>
                                </div>
                            @endif
                            <!-- Check for admin end -->

                            <a class="dropdown-item" href="{{ route('users.edit', Auth::user()->name) }}">Settings</a>
                            <a class="dropdown-item" href="{{ route('logout') }}"
                                onclick="event.preventDefault();
                                                document.getElementById('logout-form').submit();">
                                {{ __('Logout') }}
                            </a>

                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                @csrf
                            </form>
                        </div>
                    </li>
                @endguest
            </ul>
        </div>
    </div>
</nav>