@extends('layouts.app')

@section('title', 'Edit personal data')

@section('content')
    <div class="container">
        @include('partials.msg')
        @include('partials.errormsg')
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">{{__('Edit personal data')}}</div>
                    <div class="card-body p-4">
                        <form action="{{ route('users.update', $user) }}" method="POST">
                            @csrf
                            @method('PUT')
        
                            <div class="form-group">
                                <label for="Email">Email id <span class="text-danger">*</span></label>
                                <input type="email" name="email" class="form-control" value="{{ $user->email }}">
                            </div>
        
                            <div class="form-group">
                                <label for="Password">New password <span class="text-danger">*</span></label>
                                <input type="password" name="password" class="form-control">
                            </div>
        
                            <div class="form-group">
                                <label for="Email">Repeat password <span class="text-danger">*</span></label>
                                <input type="password" name="password_confirmation" class="form-control">
                            </div>
                        
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <div class="card bg-info text-light">
                    <div class="card-body">
                        <p>Use this form to change email or pawword.</p>
                        <p>On changing email, use the same password or new one.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection