@extends('layouts.app')

@section('title', 'Search directory')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card border-0 mb-2 d-flex justify-content-between">
                <div class="form-inline mb-4">
                    <h4 class="form-group mr-4">Search results</h4>
                    <span class="form-group">
                        @include('layouts.searchform')</span>                
                </div>
            </div>
                @forelse ($links as $link)
                <div class="card bg-light border-0 mt-2">
                    <div class="card-body">
                        <h6>
                            <i class="fa fa-search"></i> <a href="{{ route('link.show', $link->slug) }}">{{$link->title}}</a>
                        </h6>
                        <div>{{ substr($link->description, 0, 250) }}</div>
                    </div>
                </div>
                @empty
                    No results on your query.
                @endforelse
                {{ $links->withQueryString()->links() }}
        </div>
        <div class="col-md-3">
            {!! $admin->sideads !!}
        </div>
    </div>
</div>
@endsection